#!/bin/sh

# Check if BSP version is correct
if [ ! -e /root/BSP_ver_6_*.txt ]
then
    echo "BSP detected is not UX UI"
    exit 1
fi

# kill the vhc application
pkill vhc

#Enable product discard flash in config.txt file
/bin/sed -i 's/productDiscardFlash=.*/productDiscardFlash=1/g' /root/config.txt

#updateDir=$(dirname -- "$(readlink -f -- "${BASH_SOURCE[0]}")")
#cd "$updateDir"

# updates folders creation
if [ ! -d "/root/updates" ]; then
    mkdir /root/updates
    mkdir /root/updates/menu
    mkdir /root/updates/firmware
fi

if [ -d "updates" ]; then
    cp -r updates/* /root/updates/
    /bin/sync
fi


# preloaded menu folder creation
if [ ! -d "/root/preloadedMenus" ]; then
    mkdir /root/preloadedMenus
fi

if [ ! -d "/root/preloadedConfigs" ]; then
    mkdir /root/preloadedConfigs
fi


if [ -d "preloadedConfigs" ]; then
    cp -r preloadedConfigs/* /root/preloadedConfigs/
    /bin/sync
fi


#now copy all menuConnect files included in this package on the host.
if [ -d "menu" ]; then
    cp -r menu/* /root/preloadedMenus/
    /bin/sync
fi

# make sure this is updated 
# based on the update package
if [ -d "etc" ]; then
  cp -r etc/* /etc/
  /bin/sync
fi

if [ -d "usr" ]; then
  cp -r usr/* /usr/
  /bin/sync
  rm -f /usr/lib/libjson-c.so
  ln -s /usr/lib/libjson-c.so.4.0.0 /usr/lib/libjson-c.so
  rm -f /usr/lib/libjson-c.so.3
  ln -s /usr/lib/libjson-c.so.4.0.0 /usr/lib/libjson-c.so.3
fi

if [ -d "root" ]; then
  cp -r root/* /root/
  /bin/sync
fi

if [ -d "resources" ]; then
  cp -r resources/* /root/resources
  /bin/sync
fi

#update boot splash screen
if [ -d "splashScreen" ]; then
    cp -r splashScreen/* /usr/share/images/

    #disable uboot spalsh screen
    /usr/sbin/fw_setenv uboot_splash 0

    /bin/sync
fi


#update config file of primary UI
if [ -d "contents" ]; then
    rm /root/CFG*
    /bin/sync

    cp ./contents/*   /root/
    /bin/sync
fi

#Initialize RS485 port, CAN bus and run the update utility
stty -F /dev/ttyO1 -crtscts speed 115200 rs485 rs485rtsonsend

ip link set can0 up type can bitrate 500000

ifconfig can0 up

./vhcSystemUpdateUtil -idConnector1 -autoinstall

echo "Clean the update folder ..."
rm -rf /root/updates/firmware/*

# reboot the system - this will be an indication that the update was successful
#/sbin/reboot
